/**
 * Check if node has set passed class.
 * @method hasClass
 * @param {String} cls
 * @return {Boolean}
 */
Element.prototype.hasClass = function(cls){ return this.className.match(new RegExp( '(\\s|^)'+cls+'(\\s|$)')); }
/**
 * Add class to the node Element.
 * @method addClass
 * @param {String} cls
 */
Element.prototype.addClass = function(cls){ if (!this.hasClass(cls)) this.className += " "+cls; }
/**
 * Remove class from the node Element.
 * @method removeClass
 * @param {String} cls
 */
Element.prototype.removeClass = function(cls){ if (this.hasClass(cls)) { var reg = new RegExp('(\\s|^)'+cls+'(\\s|$)'); this.className=this.className.replace(reg,' '); }}
/**
 * Remove node
 * @method clearNode
 */
Element.prototype.remove = function(){ this.parentNode.removeChild(this )}
/**
 * Remove all children of node
 * @method clearNode
 */
Element.prototype.clear = function(){ while (this.firstChild) { this.removeChild(this.firstChild )} }
/**
 * Find coordinates x,y of node in document
 * @method findPos
 */
Element.prototype.findPos = function() {
	var x = y = 0;
	el = this;
	do {
		x += el.offsetLeft;
		y += el.offsetTop;
	} while (el = el.offsetParent);

	return {
		x : x,
		y : y
	};
}
/**
 * Set CSS property of nav-[up,right,down,left] which determines the position of current element in seq-nav-order.
 * @method setNav
 * @param {String} up - id of element
 * @param {String} right - id of element
 * @param {String} down - id of element
 * @param {String} left - id of element
 */
Element.prototype.setNav = function(up,right,down,left){
	var elem = this;
	elem.style.navUp = up?up:elem.style.navUp;
	elem.style.navRight = right?right:elem.styleRight;
	elem.style.navDown = down?down:elem.styleDown;
	elem.style.navLeft = left?left:elem.styleLeft;
}